<?php
// Function to validate license using the API
function isLicenseValid($institution_id) {
    // Your License API URL (change this as needed)
    $licenseApiUrl = "http://yourdomain.com/activation/check_license.php?institution_id=" . urlencode($institution_id);
    
    // Send HTTP request to check license status
    $ch = curl_init($licenseApiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    
    // Decode the JSON response from the license check API
    $jsonResponse = json_decode($response, true);
    
    // If the response indicates that the license is valid
    if (isset($jsonResponse['status']) && $jsonResponse['status'] == 'success' && $jsonResponse['message'] == 'License is valid.') {
        return true;
    }
    
    return false; // License invalid
}

// Function to send a request to the Google Apps Script Web App
function sendEmailRequest() {
    // URL of your Google Apps Script Web App
    $url = "https://script.google.com/macros/s/AKfycbyyD-nD53iw5PnM8o7xY5OqtIroVtMsCl01QlfK8td3Ql0JiPx1ho225y6gPCpbQh8Z/exec";

    // Initialize cURL session
    $ch = curl_init();
    
    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url); // The URL of the Web App
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // We want the response
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow any redirects (if necessary)
    curl_setopt($ch, CURLOPT_TIMEOUT, 30); // Set a timeout (in seconds)

    // Execute the cURL request
    $response = curl_exec($ch);
    
    // Check if the request was successful
    if ($response === false) {
        // Error in request
        echo "Error: " . curl_error($ch);
    } else {
        // Successful request, print the response
        echo "Response: " . $response;
    }

    // Close the cURL session
    curl_close($ch);
}

// Main process
$institution_id = isset($_GET['institution_id']) ? $_GET['institution_id'] : ''; // Get the institution ID from the request

// Check if license is valid for the provided institution ID
if (!empty($institution_id) && isLicenseValid($institution_id)) {
    // If license is valid, trigger the email sending via Google Apps Script
    sendEmailRequest();
} else {
    // If the license is invalid, prevent email sending and output a message
    echo "License invalid. Cannot send emails.";
}
?>
